/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.parsing.ast;

import beaver.spec.ast.Node;
import beaver.spec.ast.TreeWalker;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.SourcePrinter;
import com.aptana.parsing.ParsingPlugin;
import com.aptana.parsing.ast.INameNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.ast.Messages;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParseNode
extends Node
implements IParseNode {
    protected static final IParseNode[] NO_CHILDREN = new IParseNode[0];
    protected static final IParseNodeAttribute[] NO_ATTRIBUTES = new IParseNodeAttribute[0];
    private IParseNode[] fChildren = NO_CHILDREN;
    private IParseNode fParent;
    private int fChildrenCount;

    public void accept(TreeWalker walker) {
    }

    @Override
    public void addChild(IParseNode child) {
        int size = this.fChildrenCount + 1;
        int currentLength = this.fChildren.length;
        if (size > currentLength) {
            int newLength = currentLength * 3 / 2 + 1;
            IParseNode[] newList = new IParseNode[newLength];
            System.arraycopy(this.fChildren, 0, newList, 0, this.fChildrenCount);
            this.fChildren = newList;
        }
        this.fChildren[this.fChildrenCount++] = child;
        if (child instanceof ParseNode) {
            ((ParseNode)child).setParent(this);
        }
    }

    public void addOffset(int offset) {
        this.setLocation(this.getStart() + offset, this.getEnd() + offset);
    }

    @Override
    public boolean contains(int offset) {
        return this.getStartingOffset() <= offset && offset <= this.getEndingOffset();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IParseNode)) {
            return false;
        }
        IParseNode other = (IParseNode)obj;
        if (!this.getLanguage().equals(other.getLanguage())) {
            return false;
        }
        if (this.getNodeType() != other.getNodeType()) {
            return false;
        }
        return !(this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent()));
    }

    @Override
    public IParseNodeAttribute[] getAttributes() {
        return NO_ATTRIBUTES;
    }

    @Override
    public IParseNode getChild(int index) {
        if (index >= 0 && index < this.fChildrenCount) {
            return this.fChildren[index];
        }
        return null;
    }

    @Override
    public int getChildIndex(IParseNode child) {
        int result = -1;
        int i = 0;
        while (i < this.fChildrenCount) {
            if (this.fChildren[i] == child) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public int getIndex() {
        int result = -1;
        IParseNode parent = this.getParent();
        if (parent != null) {
            result = parent.getChildIndex(this);
        }
        return result;
    }

    public int getInternalChildCount() {
        return this.fChildren.length;
    }

    @Override
    public IParseNode[] getChildren() {
        IParseNode[] result = new IParseNode[this.fChildrenCount];
        if (this.fChildren.length == this.fChildrenCount) {
            result = this.fChildren;
        } else {
            result = new IParseNode[this.fChildrenCount];
            if (this.fChildrenCount > 0) {
                System.arraycopy(this.fChildren, 0, result, 0, this.fChildrenCount);
            }
        }
        return result;
    }

    @Override
    public int getChildCount() {
        return this.fChildrenCount;
    }

    @Override
    public String getElementName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getEndingOffset() {
        return this.getEnd();
    }

    @Override
    public IParseNode getNextNode() {
        IParseNode result = this.getFirstChild();
        if (result == null) {
            result = this.getNextSibling();
        }
        if (result == null) {
            IParseNode parent = this.getParent();
            while (parent != null) {
                IParseNode candidate = parent.getNextSibling();
                if (candidate != null) {
                    result = candidate;
                    break;
                }
                parent = parent.getParent();
            }
        }
        return result;
    }

    @Override
    public IParseNode getFirstChild() {
        IParseNode result = null;
        if (this.hasChildren()) {
            result = this.getChild(0);
        }
        return result;
    }

    @Override
    public IParseNode getNextSibling() {
        int index;
        IParseNode parent = this.getParent();
        IParseNode result = null;
        if (parent != null && (index = this.getIndex() + 1) < parent.getChildCount()) {
            result = parent.getChild(index);
        }
        return result;
    }

    @Override
    public int getLength() {
        return this.getEnd() - this.getStart() + 1;
    }

    @Override
    public IParseNode getLastChild() {
        IParseNode result = null;
        if (this.hasChildren()) {
            result = this.getChild(this.getChildCount() - 1);
        }
        return result;
    }

    @Override
    public INameNode getNameNode() {
        return new NameNode(this.getText(), this.getStartingOffset(), this.getEndingOffset());
    }

    @Override
    public IParseNode getNodeAtOffset(int offset) {
        IParseNode result = null;
        if (this.contains(offset)) {
            result = this;
            for (IParseNode child : this) {
                IParseNode node;
                if (!child.contains(offset) || (node = child.getNodeAtOffset(offset)) == null) continue;
                result = node;
                break;
            }
        }
        return result;
    }

    @Override
    public IParseNode getParent() {
        return this.fParent;
    }

    @Override
    public IParseNode getPreviousNode() {
        IParseNode result = this.getPreviousSibling();
        if (result != null) {
            IParseNode candidate = result.getLastChild();
            while (candidate != null) {
                result = candidate;
                candidate = candidate.getLastChild();
            }
        }
        if (result == null) {
            result = this.getParent();
        }
        return result;
    }

    @Override
    public IParseNode getPreviousSibling() {
        int index;
        IParseNode parent = this.getParent();
        IParseNode result = null;
        if (parent != null && (index = this.getIndex() - 1) >= 0) {
            result = parent.getChild(index);
        }
        return result;
    }

    @Override
    public IParseNode getRootNode() {
        IParseNode parent;
        IParseNode root = this;
        while ((parent = root.getParent()) != null) {
            root = parent;
        }
        return root;
    }

    @Override
    public int getStartingOffset() {
        return this.getStart();
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public short getNodeType() {
        return this.getId();
    }

    @Override
    public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    @Override
    public boolean isFilteredFromOutline() {
        return false;
    }

    public int hashCode() {
        int hash = 31 + this.getLanguage().hashCode();
        hash = hash * 31 + this.getNodeType();
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.end < this.start;
    }

    @Override
    public Iterator<IParseNode> iterator() {
        return new Iterator<IParseNode>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return ParseNode.this.fChildren != null && this.index < ParseNode.this.fChildrenCount;
            }

            @Override
            public IParseNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ParseNode.this.fChildren[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void replaceChild(int index, IParseNode child) throws IndexOutOfBoundsException {
        if (index >= this.fChildrenCount) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " >= " + this.fChildrenCount);
        }
        this.fChildren[index] = child;
        if (child instanceof ParseNode) {
            ((ParseNode)child).setParent(this);
        }
    }

    public void setChildren(IParseNode[] children) {
        this.fChildren = children;
        this.fChildrenCount = children.length;
        IParseNode[] iParseNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            ((ParseNode)child).setParent(this);
            ++n2;
        }
    }

    public void setLocation(int start, int end) {
        int diff = end - start;
        if (diff < -1) {
            String source;
            try {
                source = this.toString();
            }
            catch (Throwable t) {
                source = "";
            }
            String message = MessageFormat.format(Messages.ParseNode_Bad_Ending_Offset, start, end, this.getLanguage(), this.getNodeType(), source);
            IdeLog.logError((Plugin)ParsingPlugin.getDefault(), (String)message);
            end = start - 1;
        }
        super.setLocation(start, end);
    }

    public void setParent(IParseNode parent) {
        this.fParent = parent;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < this.fChildrenCount) {
            text.append(this.fChildren[i]);
            if (i < this.fChildrenCount - 1) {
                text.append(' ');
            }
            ++i;
        }
        return text.toString();
    }

    public String toXML() {
        SourcePrinter printer = new SourcePrinter();
        this.toXML(printer);
        return printer.toString();
    }

    protected void toXML(SourcePrinter printer) {
        if (this.hasChildren()) {
            printer.printWithIndent('<').print(this.getElementName()).increaseIndent();
            IParseNodeAttribute[] attrs = this.getAttributes();
            if (attrs != null) {
                IParseNodeAttribute[] iParseNodeAttributeArray = attrs;
                int n = attrs.length;
                int n2 = 0;
                while (n2 < n) {
                    IParseNodeAttribute attr = iParseNodeAttributeArray[n2];
                    printer.print(' ').print(attr.getName()).print("=\"").print(attr.getValue()).print('\"');
                    ++n2;
                }
            }
            printer.println('>');
            for (IParseNode child : this) {
                if (!(child instanceof ParseNode)) continue;
                ((ParseNode)child).toXML(printer);
            }
            printer.decreaseIndent().printWithIndent("</").print(this.getElementName()).println('>');
        } else {
            printer.printWithIndent('<').print(this.getElementName()).println("/>");
        }
    }

    public void trimToSize() {
        if (this.fChildren != null && this.fChildren.length > this.fChildrenCount) {
            this.fChildren = this.getChildren();
        }
    }

    protected static final class NameNode
    implements INameNode {
        private final String fName;
        private final int fStart;
        private final int fEnd;

        public NameNode(String name, int start, int end) {
            this.fName = name;
            this.fStart = start;
            this.fEnd = end;
        }

        public String getName() {
            return this.fName;
        }

        public IRange getNameRange() {
            return new Range(this.fStart, this.fEnd);
        }

        public String toString() {
            return this.getName();
        }
    }
}

